'******************************************************************************
' NTP routines (UDP required)                         (SVN Rev.227 9.1.2011)
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile

'-------------------------------------------------------------------------------
'  NTP Packet Filter
'-------------------------------------------------------------------------------
Sub Ntp_packet_filter
Local Lb As Byte
   If Ip_packet_is_for_me() = Nok Then Exit Sub             'Accept only packet for me
   If Ip_b_srcaddr_l <> Ntp_b_server_l Then Exit Sub        'discard package, it is not from my NTP-Server
   Lb = Ntp_b_flags And Ntp_flags_server
   If Lb <> Ntp_flags_server Then Exit Sub                  'discard package is not a reply from my server
   Call Ntp_response_received                               'Process package
End Sub

'-------------------------------------------------------------------------------
'  NTP Every Minute
'-------------------------------------------------------------------------------
Sub Ntp_every_minute
  ' If _min = 0 Then Ntp_valid = 0                           ' refresh ntp every hour
  ' Freesol: Rausgenommen, um Probleme durch fehlenden Kontakt zu NTP-Server zu vermeiden. Sowieso tglicher boot.
   If Ntp_valid = 0 Then
      Call Ntp_send_gettime                                 'get Network Time
   End If
End Sub

'-------------------------------------------------------------------------------
'  NTP Send Gettime request
'-------------------------------------------------------------------------------
Sub Ntp_send_gettime
   Call Clear_buffer                                        'Clear the complete buffer
'ETH Header
   If Arp_request_destmac_for_ip(ntp_b_server(1)) = Nok Then
      Exit Sub
   End If
   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
   Eth_w_packettype = Eth_w_packettype_ip
'IP-header
   Ip_b_vers_and_length = Ip_standard_vers_and_length       'V4, header length=5
   Ip_b_type_of_service = &H00                              'Type of service
   Ip_w_identifier = Ip_get_next_identifier()
   Ip_w_fragmentation = &H0000                              'flags & offset --> not fragmented
   Ip_b_time_to_live = &H80                                 'TTL = 255
   Ip_b_protocol = Ip_protocol_udp                          'protocol UDP
   Ip_b_srcaddr(1) = My_b_ipaddr(1)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(2) = My_b_ipaddr(2)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(3) = My_b_ipaddr(3)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(4) = My_b_ipaddr(4)                         'source address  --> My_b_ipaddr
   Ip_b_destaddr(1) = Ntp_b_server(1)
   Ip_b_destaddr(2) = Ntp_b_server(2)
   Ip_b_destaddr(3) = Ntp_b_server(3)
   Ip_b_destaddr(4) = Ntp_b_server(4)
'UDP-header
   Udp_w_src_port = Udp_port_ntp
   Udp_w_dest_port = Udp_port_ntp
'NTP Frame
   Ntp_b_flags = Ntp_flags_leap_indicator
   Shift Ntp_b_flags , Left , 3
   Ntp_b_flags = Ntp_b_flags Or Ntp_flags_version
   Shift Ntp_b_flags , Left , 3
   Ntp_b_flags = Ntp_b_flags Or Ntp_flags_client
   'all the rest can be kept empty

   Call Ip_set_packet_length(90)
   Call Ip_header_checksum
   Call Udp_set_packet_length(90)
   Call Udp_checksum
   Call Enc28j60packetsend(90)

#if Debug_ntp > 0
   Print
   Print "====================================================================="
   Print "  NTP request sent to IP ";
   Print Ip2str(ip_b_destaddr_l)
'   Call Print_ip(ip_b_destaddr(1) , No_crlf)
'   Print " via MAC " ;
'   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_ntp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Ntp_dump_frame
#endif

End Sub

'-------------------------------------------------------------------------------
'  NTP Gettime response received
'-------------------------------------------------------------------------------
Sub Ntp_response_received
Local Yl As Integer
Local Strtime As String * 8
#if Debug_ntp > 0
   Print
   Print "====================================================================="
   Print "  NTP response received from IP ";
   Print Ip2str(ip_b_destaddr_l)
'   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
'   Print " via MAC " ;
'   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_ntp > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Ntp_dump_frame
#endif

#if Debug_ntp > 1
   Print
   Print "     Recent time on NET-IO: " ; Date(netio_time) ; " " ; Time(netio_time)
#endif

' FreeSol
   Yl = _year
    If Yl = 0 Then
       Fs_startzeit_offset = Date(netio_time)
       Strtime = Time(netio_time)
       Fs_startzeit_offset = Fs_startzeit_offset + " "
       Fs_startzeit_offset = Fs_startzeit_offset + Strtime
   End If
' Freesol ende


   Netio_time = Bytes2long(ntp_b8_transmit_timestamp(4) , Ntp_b8_transmit_timestamp(3) , Ntp_b8_transmit_timestamp(2) , Ntp_b8_transmit_timestamp(1))
   Netio_time = Netio_time + Ntp_offset_to_bascom
#if Debug_ntp > 1
   Print "Time from NTP Server (UTC): " ; Date(netio_time) ; " " ; Time(netio_time)
#endif
   Netio_time = Netio_time + Ntp_one_hour_offset            ' offset UTC + 1 hour
#if Debug_ntp > 1
   Print "Time from NTP Server (GMT): " ; Date(netio_time) ; " " ; Time(netio_time)
#endif
   Call Ntp_dst_correction
#if Debug_ntp > 1
   Print "Time from NTP Server (DST): " ; Date(netio_time) ; " " ; Time(netio_time)
#endif

 ' FreeSol
   If Yl = 0 Then
       Fs_startzeit_ntp = Date(netio_time)
       Strtime = Time(netio_time)
       Fs_startzeit_ntp = Fs_startzeit_ntp + " "
       Fs_startzeit_ntp = Fs_startzeit_ntp + Strtime
   End If


#if Debug_ntp > 0
   Print
   Print "====================="
   Print "  NTP time received"
   Print "====================="
   Print "  Server: " ; Ip_b_srcaddr(1) ; "." ; Ip_b_srcaddr(2) ; "." ; Ip_b_srcaddr(3) ; "." ; Ip_b_srcaddr(4)
   Print "NTP-Date: " ; Date(netio_time)
   Print "NTP-Time: " ; Time(netio_time)
#endif

'Setting the hardware-clock
   Time$ = Time(netio_time)
   Date$ = Date(netio_time)

   Ntp_valid = 1
End Sub

Sub Ntp_dst_correction
'Dont change order of time and date variables !!! This order is required for Date/Time functions used.
Local Second As Byte
Local Minute As Byte
Local Hour As Byte
Local Day As Byte
Local Month As Byte
Local Year As Byte
Local Dow As Byte                                           'Day of week

   Day = Date(netio_time)                                   'set 3 variables: Day, Month, Year, so Year contains now current year
'DST starts at the last sunday of March, so check what weekday the 1st of April is
   Month = 4
   Day = 1
   Hour = 2
   Minute = 0
   Second = 0
   Dow = Dayofweek(day)                                     '0 = Monday to 6 = Sunday
   Day = 31 - Dow                                           'Now count back the days until last sunday
   Month = 3                                                'and set month to March
   If Netio_time >= Syssec(second) Then
       'DST ends at the last sunday of October, so check what weekday the 1st of November is
       Day = 1
       Month = 11
       Dow = Dayofweek(day)                                 '0 = Monday to 6 = Sunday
       Day = 31 - Dow                                       'Now count back the days until last sunday
       Month = 10                                           'and set month to October
       If Netio_time < Syssec(second) Then
          Netio_time = Netio_time + Ntp_one_hour_offset     'subtract one hour
          Set Ntp_it_summertime
          #if Debug_ntp > 1
             Print "It's summertime ... one hour added"
          #endif
       Else
         Reset Ntp_it_summertime

       End If





   End If

End Sub

#if Debug_ntp > 2
Sub Ntp_dump_frame
    Print "------------------------"
    Print "  NTP Data (48) Bytes"
    Print "------------------------"
    Print "       Flags: " ; : Call Print_byte(ntp_b_flags , No_crlf) : Print "   [" ; Bin(ntp_b_flags) ; "]"
    Print "Peer Stratum: " ; : Call Print_byte(ntp_b_peer_clock_stratum , Crlf)
    Print "P PollInterv: " ; : Call Print_byte(ntp_b_peer_clock_stratum , Crlf)
    Print "P ClkPrecise: " ; : Call Print_byte(ntp_b_peer_clock_stratum , Crlf)
    Print "  Root delay: " ; : Call Print_long(ntp_l_root_delay , Crlf)
    Print "Root dispers: " ; : Call Print_long(ntp_l_root_dispersion , Crlf)
    Print "    Clock Id: " ; Chr(ntp_b4_ref_clock_id(1)) ; Chr(ntp_b4_ref_clock_id(2)) ; Chr(ntp_b4_ref_clock_id(3)) ; Chr(ntp_b4_ref_clock_id(4))
    Print "RefClkUpdate: " ; : Call Print_hexbytes(ntp_b8_ref_clock_update_time(1) , 4 , No_crlf) : Print "." ; : Call Print_hexbytes(ntp_b8_ref_clock_update_time(5) , 4 , Crlf)
    Print "Orig TmStamp: " ; : Call Print_hexbytes(ntp_b8_originate_timestamp(1) , 4 , No_crlf) : Print "." ; : Call Print_hexbytes(ntp_b8_originate_timestamp(5) , 4 , Crlf)
    Print " Rcv TmStamp: " ; : Call Print_hexbytes(ntp_b8_receive_timestamp(1) , 4 , No_crlf) : Print "." ; : Call Print_hexbytes(ntp_b8_receive_timestamp(5) , 4 , Crlf)
    Print "Xmit TmStamp: " ; : Call Print_hexbytes(ntp_b8_transmit_timestamp(1) , 4 , No_crlf) : Print "." ; : Call Print_hexbytes(ntp_b8_transmit_timestamp(5) , 4 , Crlf)
End Sub
#endif